/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IConditionalExpression.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents a conditional expression.
 * 
 * <p>
 * <code>
 *     condition_expression ? then_expression : else_expression
 * </code>
 * </p>
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li> condition </li>
 * <li> then-expression </li>
 * <li> else-expression </li>
 * </ul>
 * 
 */

public interface IConditionalExpression extends IExpression {
	
   /**
     * returns the condition
     * 
     * @return condition
     */		
	public IExpression getExpression();

   /**
     * returns the then-expression (second operand)
     * 
     * @return then-expression
     */		
	public IExpression getThenExpression();

   /**
     * returns the else-expression (third operand)
     * 
     * @return else-expression
     */	
   	public IExpression getElseExpression();
}
