/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/ICompilationUnit.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

import java.util.List;

/**
 * Represents a compilation unit.
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li>  package declaration </li>
 * <li>  import declarations </li>
 * <li>  type declarations </li>
 * </ul>
 * 
 */

public interface ICompilationUnit extends Position, Traversable {

	/**
	  * returns the absolute name of the file containing the compilation unit (<code>null</code> if unknown);
	  * 
	  * @return file name
	  */
	public String getFileName();

	/**
	  * returns the package declaration (or <code>null</code> if the compilation 
	  * unit belongs to an anonymous package).
	  * 
	  * @return package declaration
	  */
	public IPackageDeclaration getPackage();

	/**
	  * returns the list of import declarations (each of which is an instance of IImportDeclaration).
	  * If the compilation unit does not contain any import declaration, the method returns an empty 
	  * list (not <code>null</code>).
	  * 
	  * @return list of import declarations
	  */
	public List imports();

	/**
	  * returns the list of top-level type declarations (each of which is an instance of ITypeDeclaration).
	  * If the compilation unit does not contain any type declaration, the method returns an empty 
	  * list (not <code>null</code>).
	  * 
	  * @return list of type declarations
	  */
	public List types();

	/**
	  * returns the line number corresponding to a given offset (or -1 if the 
	  * offset does not lie within the compilation unit boundaries).
	  * 
	  * @param position offset
	  * @return line number
	  */
	public int lineNumber(int position);

	/**
	  * returns the column number corresponding to a given offset (or -1 if the 
	  * offset does not lie within the compilation unit boundaries).
	  * 
	  * @param position offset
	  * @return column number
	  */
	public int columnNumber(int position);
  
  /**
   * @return number of source lines 
   */
  public int lineCount();


}
