/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IComment.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents a comment.
 */
public interface IComment extends Position {
	/**
	 * end-of-line comment (introduced by //)
	 */
	public static final int END_OF_LINE_COMMENT = 0;
	
	/**
	 * block comment (introduced by /*)
	 */
	public static final int BLOCK_COMMENT = 1;
	
	/**
	 * Javadoc comment
	 */
	public static final int JAVADOC_COMMENT = 2;
		
	/**
	 * returns the comment type
	 * 
	 * @return comment type
	 */
    public int getCommentType();
    
    /**
     * return the comment text (including opening and closing comment tags)
     * 
     * @return comment text
     */
    public String getText();
}
