/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IClassInstanceCreation.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

import java.util.List;

/**
 * Represents a class instance creation.
 * 
 * Example:
 * <p>
 * <code>
 *     prefixExpression.new SomeClass(par_1, ..., par_n){
 *         anonymousClass_body
 *     } 
 * </code>
 * </p>  
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li>  name </li>
 * <li>  prefix expression </li>
 * <li>  arguments </li>
 * <li>  anonymous class </li>
 * </ul>
 * 
 */

public interface IClassInstanceCreation extends IExpression {

   /**
     * returns the expression prefixing the new operator (or <code>null</code>).
     * 
     * @return new-prefix expression
     */   
	public IExpression getExpression();

   /**
     * returns the name of the instantiated class.
     * 
     * @return name of the instantiated class
     */  
	public IName getName();
	
   /**
     * returns the list or constructor arguments (each of which is an instance of IExpression). 
     * The list may be empty (but not <code>null</code>).
     * 
     * @return list of constructor arguments
     */ 
	public List arguments();
	
   /**
     * returns the anonymous class declaration (or <code>null</code>).
     * 
     * @return anonymous class declaration
     */ 	
	public IAnonymousClassDeclaration getAnonymousClassDeclaration();
	
   /**
     * returns the constructor binding (or <code>null</code> if the constructor cannot be resolved).
     * 
     * @return constructor binding
     */ 	
	public IMethodBinding resolveConstructorBinding();
}

