/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/ICatchClause.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents a catch clause.
 * 
 * Example:
 * 
 * <p>
 * <code>
 *     catch (exceptionType exceptionVariable) {
 *         stmt_1;
 *         ...
 *         stmt_n;
 *     }
 * </code>
 * </p>
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li>  exception </li>
 * <li>  body </li>
 * </ul>
 * 
 */

public interface ICatchClause extends Position, Traversable, Commentable  {

   /**
     * returns the exception variable declaration.
     * 
     * @return variable declaration
     */ 
	public IVariableDeclaration getException();
	
   /**
     * returns the catch block.
     * 
     * @return catch block
     */ 	
	public IBlock getBody();
}
