/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/ICastExpression.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents a cast expression.
 * 
 * <p>
 * <code>
 *     (type)expression
 * </code>
 * </p>
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li>  type</li>
 * <li>  expression </li>
 * </ul>
 * 
 */

public interface ICastExpression extends IExpression {

   /**
     * returns the type to which the expressin is cast.
     * 
     * @return cast type
     */ 
	public IType getType();
	
   /**
     * returns the expression.
     * 
     * @return expression
     */ 	
	public IExpression getExpression(); 
}
