/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IBlock.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

import java.util.List;

/**
 * Represents an  statement block. Example:
 * 
 * <p>
 * <code>
 * {
 *     stmt_1;
 *     ...
 *     stmt_n;
 * }  
 * </code>
 * </p>  
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li>  statements, according to their source code ordering.</li>
 * </ul>
 * 
 */

public interface IBlock extends IStatement {

   /**
     * returns the list of statements (each of which is an instance of IStatement). If the block 
     * does not contain any statement, the method returns an empty list (not <code>null</code>).
     * 
     * @return list of statements
     */
	public List statements();
}

