/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IAssignment.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents an  assignment expression.
 * 
 * 
 * <p>
 * <code>
 *     leftHandSideExpression op rightHandSideExpression  
 * </code>
 * </p>  
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li> left hand side </li>
 * <li> right hand side </li>
 * </ul>
 * 
 */

public interface IAssignment extends IExpression {
	/** = operator. */
	public static final String ASSIGN = "="; //$NON-NLS-1$
	/** += operator. */
	public static final String PLUS_ASSIGN = "+="; //$NON-NLS-1$
	/** -= operator. */
	public static final String MINUS_ASSIGN = "-="; //$NON-NLS-1$
	/** *= operator. */
	public static final String TIMES_ASSIGN = "*="; //$NON-NLS-1$
	/** /= operator. */
	public static final String DIVIDE_ASSIGN = "/="; //$NON-NLS-1$
	/** &amp;= operator. */
	public static final String BIT_AND_ASSIGN = "&="; //$NON-NLS-1$
	/** |= operator. */
	public static final String BIT_OR_ASSIGN = "|="; //$NON-NLS-1$
	/** ^= operator. */
	public static final String BIT_XOR_ASSIGN = "^="; //$NON-NLS-1$
	/** %= operator. */
	public static final String REMAINDER_ASSIGN = "%="; //$NON-NLS-1$
	/** &lt;&lt;== operator. */
	public static final String LEFT_SHIFT_ASSIGN = "<<="; //$NON-NLS-1$
	/** &gt;&gt;== operator. */
	public static final String RIGHT_SHIFT_SIGNED_ASSIGN = ">>="; //$NON-NLS-1$
	/** &gt;&gt;&gt;== operator. */
	public static final String RIGHT_SHIFT_UNSIGNED_ASSIGN = ">>>="; //$NON-NLS-1$

	/**
	  * returns the operator string
	  * 
	  * @return operator string
	  */
	public String getOperator();

	/**
	  * returns the left hand side expression
	  * 
	  * @return left hand side expression
	  */
	public IExpression getLeftHandSide();

	/**
	  * returns the right hand side expression
	  * 
	  * @return right hand side expression
	  */
	public IExpression getRightHandSide();
}
