/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IArrayType.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * 
 * Represents an  array type.
 * <p>
 * 
 */
 
public interface IArrayType extends IType {

   /**
     * returns the component type (i.e. (element, dim) -> (element, dim-1)).
     * 
     * @return component type
     */    
 	public ITypeBinding getComponentType();

   /**
     * returns the element type (i.e. a[][]..[] -> a).
     * 
     * @return element type
     */   
 	public ITypeBinding getElementType();
 	
   /**
     * returns the number of dimensions.
     * 
     * @return dimensions
     */    	
	public int getDimensions();
}

