/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IArrayInitializer.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

import java.util.List;

/**
 * Represents an  array initializer expression.
 * 
 * Example: <code>{initializer_1,...initializer_m}</code> in:
 * <p>
 * <code>
 *     new SomeClass[dimension_1]...[dimension_n]{initializer_1,...initializer_m} ;
 * </code>
 * </p>  
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li> expressions </li>
 * </ul>
 * 
 */

public interface IArrayInitializer extends IExpression {

   /**
     * returns a list (each element of which is an instance of IExpression) of the 
     * initializer components.
     * 
     * @return list of initializer components
     */  
	public List expressions();
}

