/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IArrayCreation.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

import java.util.List;

/**
 * Represents an  array creation expression.
 * 
 * Example:
 * <p>
 * <code>
 *     new SomeClass[dimension_1]...[dimension_n]{initializer_1,...,initializer_m}  
 * </code>
 * </p>  
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li> type </li>
 * <li> dimensions </li>
 * <li> initializer </li>
 * </ul>
 * 
 */
 
public interface IArrayCreation extends IExpression {

   /**
     * returns the array type
     * 
     * @return array type
     */	
    public IArrayType getType();
    
   /**
     * returns a list (each element of which is an instance of IExpression) of the array
     * dimension expressions. The list contains as many elements as the array dimensions. 
     * List elements may be <code>null</code> if the dimension expression is missing.
     * 
     * @return list of dimension expressions
     */    
	public List dimensions();
	
   /**
     * returns the array initializer ( or <code>null</code>)
     * 
     * @return array initializer
     */    	
	public IArrayInitializer getInitializer();
}

