/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IAnonymousClassDeclaration.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

import java.util.List;

/**
 * Represents an  anonymous class declaration. 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li>  body declarations, according to their source code ordering.</li>
 * </ul>
 * 
 */

public interface IAnonymousClassDeclaration extends Position, Traversable, Commentable  {

   /**
     * returns a list (each element of which is an instance of either IFieldDeclaration,
     * IMethodDeclaration, IInitializer, or ITypeDeclaration) of class members. If the class 
     * does not contain any member, the method returns an empty list (not <code>null</code>).
     * 
     * @return list of class members
     */
	public List bodyDeclarations(); 

   /**
     * returns the type binding 
     * 
     * @return type binding 
     * 
     */
	public IReferenceTypeBinding resolveBinding();
}

 
