/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/Commentable.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents a commentable element. 
 * 
 */
public interface Commentable {
 	
 	/**
 	 * returns block comments following the element code
 	 * 
 	 * @return block comments
 	 */
	public IComment[] getComments();
 	
 	/**
 	 * return the end-of-line comment (if present) on the same line as the last
 	 * character of the element code
 	 * 
 	 * @return end-of-line comment
 	 */
	public IComment getEndOfLineComment();
}
