/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/Wrapper.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;

 
public class Wrapper {
	public static IExpression wrapExpression(org.eclipse.jdt.internal.compiler.ast.Expression expr,
	                                           org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
	                                           SourceContent source) {
		if (expr == null)
			return null;
		if (expr instanceof ArrayReference)
			return new ArrayAccess((ArrayReference) expr,scope,source);
		if (expr instanceof ArrayAllocationExpression)
			return new ArrayCreation((ArrayAllocationExpression) expr,scope,source);
		if (expr instanceof org.eclipse.jdt.internal.compiler.ast.ArrayInitializer)
			return new ArrayInitializer((org.eclipse.jdt.internal.compiler.ast.ArrayInitializer) expr,scope,source);
		if (expr instanceof org.eclipse.jdt.internal.compiler.ast.PrefixExpression)
			return new PrefixExpressionFromPrefixExpression((org.eclipse.jdt.internal.compiler.ast.PrefixExpression) expr,scope);
		if (expr instanceof org.eclipse.jdt.internal.compiler.ast.PostfixExpression)
			return new PostfixExpression((org.eclipse.jdt.internal.compiler.ast.PostfixExpression) expr,scope);
		if (expr instanceof org.eclipse.jdt.internal.compiler.ast.Assignment)
			return new Assignment((org.eclipse.jdt.internal.compiler.ast.Assignment) expr,scope,source);
		if (expr instanceof TrueLiteral)
			return new BooleanLiteral((TrueLiteral) expr);
		if (expr instanceof FalseLiteral)
			return new BooleanLiteral((FalseLiteral) expr);
		if (expr instanceof org.eclipse.jdt.internal.compiler.ast.CastExpression)
			return new CastExpression((org.eclipse.jdt.internal.compiler.ast.CastExpression) expr,scope,source);
		if (expr instanceof AllocationExpression)
			return new ClassInstanceCreation((AllocationExpression) expr,scope,source);
		if (expr instanceof org.eclipse.jdt.internal.compiler.ast.ConditionalExpression)
			return new ConditionalExpression((org.eclipse.jdt.internal.compiler.ast.ConditionalExpression) expr,scope,source);
		if (expr instanceof FieldReference)
			return new FieldAccessFromFieldReference((FieldReference) expr,scope,source);
		if (expr instanceof BinaryExpression)
			return new InfixExpression((BinaryExpression) expr,scope,source);
		if (expr instanceof org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression)
			return new InstanceofExpression((org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression) expr,scope,source);
		if (expr instanceof MessageSend) {
			if ( ((MessageSend)expr).receiver != null 
			       && (((MessageSend)expr).receiver instanceof
			           SuperReference  ||
						((MessageSend)expr).receiver instanceof
							QualifiedSuperReference ))
			    return new SuperMethodInvocation((MessageSend)expr,scope,source);	 
			return new MethodInvocation((MessageSend) expr,scope,source);
		}
		if (expr instanceof QualifiedNameReference) {
			return wrapQualifiedName((QualifiedNameReference)expr, scope,source);
		}
		if (expr instanceof SingleNameReference)
			return new SimpleNameFromSingleNameReference((SingleNameReference) expr);
		if (expr instanceof org.eclipse.jdt.internal.compiler.ast.NullLiteral)
			return new NullLiteral((org.eclipse.jdt.internal.compiler.ast.NullLiteral) expr);
		if (expr instanceof org.eclipse.jdt.internal.compiler.ast.CharLiteral)
			return new CharacterLiteral((org.eclipse.jdt.internal.compiler.ast.CharLiteral) expr);
		if (expr instanceof org.eclipse.jdt.internal.compiler.ast.NumberLiteral)
			return new NumberLiteral((org.eclipse.jdt.internal.compiler.ast.NumberLiteral) expr);
		if (expr instanceof UnaryExpression)  
			    return new PrefixExpressionFromUnaryExpression((UnaryExpression) expr,scope,source);
		if (expr instanceof org.eclipse.jdt.internal.compiler.ast.StringLiteral)
			return new StringLiteral((org.eclipse.jdt.internal.compiler.ast.StringLiteral) expr, scope, source);
		if (expr instanceof SuperReference || expr instanceof QualifiedSuperReference)
			return new SuperExpression((ThisReference) expr, scope);
		if (expr instanceof ThisReference)
			return new ThisExpression((ThisReference) expr, scope);
		if (expr instanceof ClassLiteralAccess)
			return new TypeLiteral((ClassLiteralAccess) expr);
		throw new IllegalArgumentException("illegal expression type: " + expr.getClass().getName());
	}


	public static IStatement wrapStatement(org.eclipse.jdt.internal.compiler.ast.Statement stmt,
	                                           org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,SourceContent source) {
		if (stmt == null)
			return null;
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.AssertStatement)
			return new AssertStatement((org.eclipse.jdt.internal.compiler.ast.AssertStatement) stmt,scope,source);
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.Block) {
				return new Block((org.eclipse.jdt.internal.compiler.ast.Block) stmt,source);
		}
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.Break)
			return new BreakStatement((org.eclipse.jdt.internal.compiler.ast.Break) stmt,source);
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall) {
		    if (((org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall)stmt).isSuperAccess())
			    return new SuperConstructorInvocation((org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall) stmt,scope,source);
			else
			    return new ConstructorInvocation((org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall) stmt,scope,source);			 
		}
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.Continue)
			return new ContinueStatement((org.eclipse.jdt.internal.compiler.ast.Continue) stmt,source);
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.DoStatement)
			return new DoStatement((org.eclipse.jdt.internal.compiler.ast.DoStatement) stmt,scope,source);
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.EmptyStatement)
			return new EmptyStatement((org.eclipse.jdt.internal.compiler.ast.EmptyStatement) stmt,source);
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.Expression)
			return new ExpressionStatement((org.eclipse.jdt.internal.compiler.ast.Expression) stmt,scope,source);
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.ForStatement)
			return new ForStatement((org.eclipse.jdt.internal.compiler.ast.ForStatement) stmt,scope,source);
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.IfStatement)
			return new IfStatement((org.eclipse.jdt.internal.compiler.ast.IfStatement) stmt,scope,source);
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.LabeledStatement)
			return new LabeledStatement((org.eclipse.jdt.internal.compiler.ast.LabeledStatement) stmt,scope,source);
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.ReturnStatement)
			return new ReturnStatement((org.eclipse.jdt.internal.compiler.ast.ReturnStatement) stmt,scope,source);
		/*		if (stmt instanceof org.eclipse.jdt.core.dom.SuperConstructorInvocation)
						out.add( new SuperConstructorInvocation(
							(org.eclipse.jdt.core.dom.SuperConstructorInvocation) stmt)); */
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.Case)
			return new SwitchCaseFromCase((org.eclipse.jdt.internal.compiler.ast.Case) stmt,scope,source);
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.DefaultCase)
			return new SwitchCaseFromDefault((org.eclipse.jdt.internal.compiler.ast.DefaultCase) stmt, scope, source);
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.SwitchStatement)
			return new SwitchStatement((org.eclipse.jdt.internal.compiler.ast.SwitchStatement) stmt,scope,source);
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement)
			return new SynchronizedStatement((org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement) stmt,scope,source);
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.ThrowStatement)
			return new ThrowStatement((org.eclipse.jdt.internal.compiler.ast.ThrowStatement) stmt,scope,source);
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.TryStatement)
			return new TryStatement((org.eclipse.jdt.internal.compiler.ast.TryStatement) stmt,scope,source);
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)
			return new TypeDeclarationStatement((org.eclipse.jdt.internal.compiler.ast.TypeDeclaration) stmt,scope,source); 
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.LocalDeclaration)
			return new VariableDeclarationStatement((org.eclipse.jdt.internal.compiler.ast.LocalDeclaration) stmt,scope,source);
		if (stmt instanceof org.eclipse.jdt.internal.compiler.ast.WhileStatement)
			return new WhileStatement((org.eclipse.jdt.internal.compiler.ast.WhileStatement) stmt,scope,source);
			throw new IllegalArgumentException("illegal statement type: " 
												+ stmt.getClass().getName());      	

	}
	
	public static IExpression wrapQualifiedName(QualifiedNameReference expr,
	                                           org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
	SourceContent source) {
	        int tokenLength =  expr.tokens.length;
	        int prefixLength = tokenLength - 1 - ((expr.otherBindings == null ) ? 0 : expr.otherBindings.length);
	        FieldBinding[] otherBindings = expr.otherBindings;
	        if ( otherBindings == null  ) { // prefix.f
	        	if ( expr.binding instanceof FieldBinding ) {
	        	    return new FieldAccessFromQualifiedNameReference(expr,scope,source,prefixLength);	
	        	} 
				if ( expr.binding instanceof TypeBinding ) {
					return new QualifiedNameFromQualifiedNameReference(expr);	
				} 			
				throw new IllegalArgumentException("illegal qualified name reference: " 
													+ expr.getClass().getName());      	
	        }
	        return new FieldAccessFromQualifiedNameReference(expr,scope,source,tokenLength-1);	
    }
}
