/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/WhileStatement.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.ast.Statement;

import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class WhileStatement implements IWhileStatement {

	private org.eclipse.jdt.internal.compiler.ast.WhileStatement ws;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IExpression expr;
	private IStatement body;
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed = false;

	public WhileStatement(
		org.eclipse.jdt.internal.compiler.ast.WhileStatement ws,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.ws = ws;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.WHILE_STATEMENT;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement#getExpression()
	 */
	public IExpression getExpression() {
		if (expr == null) {
			expr = Wrapper.wrapExpression(ws.condition, scope, source);
		}
		return expr;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement#getBody()
	 */
	public IStatement getBody() {
		if (body == null) {
			if (ws.action != null) {
				body = Wrapper.wrapStatement(ws.action, scope, source);
			} else {
				body = new EmptyStatement(ws.sourceEnd, source);
			}
		}
		return body;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return ws.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			getExpression().traverse(visitor);
			if (getBody() != null)
				getBody().traverse(visitor);
		}
		visitor.endVisit(this);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment[] getComments() {
		if (comments == null) {
			comments = source.getBlockComment(ws.sourceEnd);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment = source.getEndOfLineComment(ws.sourceEnd);
      commentParsed = true;
		}
		return endOfLineComment;
	}

}
