/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/VariableDeclarationStatement.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IType;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

/**
 * @author d034036
 */
public class VariableDeclarationStatement
	implements IVariableDeclarationStatement {

	private AbstractVariableDeclaration decl;
	private BlockScope scope;
	private SourceContent source;

	/* cache */
	private IType type;
	private IExpression initializer;
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed = false;

	public VariableDeclarationStatement(
		AbstractVariableDeclaration decl,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.decl = decl;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.VARIABLE_DECLARATION_STATEMENT;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationStatement#getModifiers()
	 */
	public int getModifiers() {
		return decl.modifiers;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationStatement#getType()
	 */
	public IType getType() {
		if (type == null) {
			TypeReference tr = decl.type;
			if (tr.dimensions() == 0) {
				type = new SimpleTypeFromTypeReference(tr);
			} else if (tr instanceof ArrayTypeReference) {
				type = new ArrayTypeFromTypeReference((ArrayTypeReference) tr);
			} else if (tr instanceof ArrayQualifiedTypeReference) {
				type =
					new ArrayTypeFromTypeReference(
						(ArrayQualifiedTypeReference) tr);
			}
		}
		return type;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration#getName()
	 */
	public String getName() {
		return new String(decl.name);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration#getInitializer()
	 */
	public IExpression getInitializer() {
		if (initializer == null && decl.initialization != null) {
			initializer =
				Wrapper.wrapExpression(decl.initialization, scope, source);
		}
		return initializer;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration#resolveBinding()
	 */
	public IVariableBinding resolveBinding() {
		if (decl instanceof FieldDeclaration)
			return new VariableBinding(((FieldDeclaration) decl).binding);
		if (decl instanceof LocalDeclaration)
			return new VariableBinding(((LocalDeclaration) decl).binding);
		return null;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return decl.sourceStart; // TODO: or decl.declarationSourceStart;??
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			getType().traverse(visitor);
			IExpression init = getInitializer();
			if (init != null)
				init.traverse(visitor);
		}
		visitor.endVisit(this);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment[] getComments() {
		if (comments == null) {
			comments = source.getBlockComment(decl.declarationSourceEnd + 1);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment =
				source.getEndOfLineComment(decl.declarationSourceEnd + 1);
      commentParsed = true;
		}
		return endOfLineComment;
	}

}
