/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/VariableBinding.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;

public class VariableBinding implements IVariableBinding {

	private org.eclipse.jdt.internal.compiler.lookup.VariableBinding vBinding;

	public VariableBinding(
		org.eclipse.jdt.internal.compiler.lookup.VariableBinding vBinding) {
		this.vBinding = vBinding;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#getName()
	 */
	public String getName() {
		return new String(vBinding.name);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding#getDeclaringClass()
	 */
	public ITypeBinding getDeclaringClass() {
		if (!(vBinding instanceof FieldBinding))
			return null;
		ReferenceBinding declClass = ((FieldBinding) vBinding).declaringClass;
		if (declClass == null)
			return null;
		return BindingFactory.getTypeBinding(declClass);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding#getType()
	 */
	public ITypeBinding getType() {
		return BindingFactory.getTypeBinding(vBinding.type);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#getKind()
	 */
	public int getKind() {
		return IBinding.VARIABLE;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#getModifiers()
	 */
	public int getModifiers() {
		return vBinding.modifiers & 0x0fff; // first byte used jdt-internally
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#isDeprecated()
	 */
	public boolean isDeprecated() {
		return false;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding#isField()
	 */
	public boolean isField() {
		return vBinding instanceof FieldBinding;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#equals(com.sap.tc.jtools.jlint.jom.interfaces.IBinding)
	 */
	public boolean equals(Object binding) {
		return (binding instanceof VariableBinding)
			&& (((VariableBinding) binding).vBinding.equals(vBinding));
	}

  public int hashCode() {
    return vBinding.hashCode();
  }

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding#getValue()
	 */
	public String getValue() {
		if (!vBinding.isConstantValue() || vBinding.constant == null) {
			return null;
		}
		return vBinding.constant.stringValue();

	}
}
