/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/TypeDeclaration.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import java.util.Vector;

import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.InnerTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.IConstants;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

import com.sap.tc.jtools.jlint.jom.interfaces.IBodyDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IJavadoc;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IName;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;

public class TypeDeclaration implements ITypeDeclaration {

	private org.eclipse.jdt.internal.compiler.ast.TypeDeclaration td;
	private SourceContent source = null;

	/* cache */
	private ISimpleName name;
	private IName superClass;
	private IName[] sis;
	private IBodyDeclaration[] bodyDeclarations;
	private IJavadoc javadoc;
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed = false;

	public TypeDeclaration(
		org.eclipse.jdt.internal.compiler.ast.TypeDeclaration td,
		SourceContent source) {
		this.td = td;
		this.source = source;
		if (td.binding.isLocalType())
			return;

		AbstractMethodDeclaration[] temp = td.methods;
		if (temp != null) {
			for (int i = 0; i < temp.length; i++) {
				if (temp[i]
					instanceof org.eclipse.jdt.internal.compiler.ast.MethodDeclaration) {
					org
						.eclipse
						.jdt
						.internal
						.compiler
						.ast
						.MethodDeclaration methodDeclaration =
						(org
							.eclipse
							.jdt
							.internal
							.compiler
							.ast
							.MethodDeclaration) temp[i];
					temp[i].binding.returnType =
						methodDeclaration.returnType.resolveType(temp[i].scope);
					Argument[] arguments = temp[i].arguments;
					if (arguments != null) {
						temp[i].binding.parameters =
							new org
								.eclipse
								.jdt
								.internal
								.compiler
								.lookup
								.TypeBinding[arguments
								.length];
						for (int ii = 0; ii < arguments.length; ii++) {
							org
								.eclipse
								.jdt
								.internal
								.compiler
								.lookup
								.TypeBinding tb =
								arguments[ii].type.getTypeBinding(td.scope);
							arguments[ii].bind(temp[i].scope, tb, false);
							temp[i].binding.parameters[ii] = tb;
						}
					}
					TypeReference[] exceptions = temp[i].thrownExceptions;
					if (exceptions != null) {
						temp[i].binding.thrownExceptions =
							new ReferenceBinding[exceptions.length];
						for (int ii = 0; ii < exceptions.length; ii++) {
							temp[i].thrownExceptions[ii].resolve(temp[i].scope);
							temp[i].binding.thrownExceptions[ii] =
								(
									ReferenceBinding) temp[i]
										.thrownExceptions[ii]
										.resolvedType;
						}
					}
					temp[i].resolve(td.scope);

				} else if (
					temp[i]
						instanceof org
							.eclipse
							.jdt
							.internal
							.compiler
							.ast
							.ConstructorDeclaration) {
					Argument[] arguments = temp[i].arguments;
					if (arguments != null) {
						temp[i].binding.parameters =
							new org
								.eclipse
								.jdt
								.internal
								.compiler
								.lookup
								.TypeBinding[arguments
								.length];
						for (int ii = 0; ii < arguments.length; ii++) {
							org
								.eclipse
								.jdt
								.internal
								.compiler
								.lookup
								.TypeBinding tb =
								arguments[ii].type.getTypeBinding(td.scope);
							arguments[ii].bind(temp[i].scope, tb, false);
							temp[i].binding.parameters[ii] = tb;
						}
					}
					TypeReference[] exceptions = temp[i].thrownExceptions;
					if (exceptions != null) {
						temp[i].binding.thrownExceptions =
							new ReferenceBinding[exceptions.length];
						for (int ii = 0; ii < exceptions.length; ii++) {
							temp[i].thrownExceptions[ii].resolve(temp[i].scope);
							temp[i].binding.thrownExceptions[ii] =
								(
									ReferenceBinding) temp[i]
										.thrownExceptions[ii]
										.resolvedType;
						}
					}
					temp[i].resolve(td.scope);
				}
			}
		}
		org.eclipse.jdt.internal.compiler.ast.FieldDeclaration[] fields =
			td.fields;
		if (fields != null) {
			for (int i = 0; i < fields.length; i++) {
				if (fields[i]
					instanceof org.eclipse.jdt.internal.compiler.ast.Initializer) {
					(
						(
							org
								.eclipse
								.jdt
								.internal
								.compiler
								.ast
								.Initializer) fields[i])
								.resolve(
						td.initializerScope);
					continue;
				}
				fields[i].binding.type =
					fields[i].type.getTypeBinding(td.scope);
				if (fields[i].isStatic()) {
					fields[i].resolve(td.staticInitializerScope);
				} else {
					fields[i].resolve(td.initializerScope);
				}
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.TYPE_DECLARATION;
	}

	public int getStartPosition() {
		return td.declarationSourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration#isInterface()
	 */
	public boolean isInterface() {
		return td.isInterface();
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration#getModifiers()
	 */
	public int getModifiers() {
		return td.modifiers & ~IConstants.AccInterface;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration#getName()
	 */
	public ISimpleName getName() {
		if (name == null) {
			name =
				new SimpleNameFromString(
					new String(td.name),
					td.sourceStart,
					BindingFactory.getTypeBinding(td.binding));
		}
		return name;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration#getSuperclass()
	 */
	public IName getSuperclass() {
		if (superClass == null) {
			TypeReference sc = td.superclass;
			if (sc != null) {
				TypeReference tr = td.superclass;
				char[][] tokens = tr.getTypeName();
				if (tokens.length == 1) {
					superClass = new SimpleNameFromTypeReference(td.superclass);
				} else {
					superClass = new QualifiedNameFromTypeReference(tr);
				}
			}
		}
		return superClass;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration#superInterfaces()
	 */
	public IName[] getSuperInterfaces() {
		if (sis == null) {
			Vector out = new Vector();
			TypeReference[] superInterfaces = td.superInterfaces;
			if (superInterfaces != null) {
				for (int i = 0; i < superInterfaces.length; i++) {
					char[][] name = superInterfaces[i].getTypeName();
					if (name.length == 1) {
						out.add(
							new SimpleNameFromTypeReference(superInterfaces[i]));
					} else {
						out.add(
							new QualifiedNameFromTypeReference(superInterfaces[i]));
					}
				}
			}
			sis = (IName[]) out.toArray(new IName[out.size()]);
		}
		return sis;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration#bodyDeclarations()
	 */
	public IBodyDeclaration[] getBodyDeclarations() {
		if (bodyDeclarations == null) {
			Vector out = new Vector() {
				public boolean add(Object o) {
					int position = ((Position) o).getStartPosition();
					int currentSize = size();
					for (int i = 0; i < currentSize; i++) {
						if (position
							< ((Position) get(i)).getStartPosition()) {
							add(i, o);
							return true;
						}

					}
					return super.add(o);
				}
			};

			org.eclipse.jdt.internal.compiler.ast.FieldDeclaration[] fields =
				td.fields;
			if (fields != null) {
				for (int i = 0; i < fields.length; i++) {
					if (fields[i]
						instanceof org.eclipse.jdt.internal.compiler.ast.Initializer)
						out.add(
							new InitializerFromInitializer(
								(org
									.eclipse
									.jdt
									.internal
									.compiler
									.ast
									.Initializer) fields[i],
								td.initializerScope,
								source));
					else
						out.add(
							new FieldDeclaration(
								fields[i],
								td.initializerScope,
								source));
				}

			}
			AbstractMethodDeclaration[] methods = td.methods;
			if (methods != null) {
				for (int i = 0; i < methods.length; i++) {
					if (methods[i].isDefaultConstructor())
						continue;
					if (methods[i] instanceof Clinit);
					//implicit initializer  out.add(new Initializer((org.eclipse.jdt.internal.compiler.ast.Clinit) methods[i]));
					else
						out.add(
							new MethodDeclaration(
								methods[i],
								td.initializerScope,
								source));
				}
			}
			MemberTypeDeclaration[] types = td.memberTypes;
			if (types != null) {
				for (int i = 0; i < types.length; i++) {
					out.add(new TypeDeclaration(types[i], source));
				}
			}
			bodyDeclarations =
				(IBodyDeclaration[]) out.toArray(
					new IBodyDeclaration[out.size()]);
		}
		return bodyDeclarations;

	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration#getFields()
	 */
	public IFieldDeclaration[] getFields() {
		IBodyDeclaration[] bds = getBodyDeclarations();
		Vector outVector = new Vector();
		for (int i = 0; i < bds.length; i++) {
			if (bds[i] instanceof IFieldDeclaration) {
				outVector.add(bds[i]);
			}
		}
		return (IFieldDeclaration[]) outVector.toArray(
			new FieldDeclaration[outVector.size()]);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration#getMethods()
	 */
	public IMethodDeclaration[] getMethods() {
		IBodyDeclaration[] bds = getBodyDeclarations();
		Vector out = new Vector();
		for (int i = 0; i < bds.length; i++) {
			if (bds[i] instanceof IMethodDeclaration) {
				out.add(bds[i]);
			}
		}
		return (MethodDeclaration[]) out.toArray(
			new MethodDeclaration[out.size()]);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration#getTypes()
	 */
	public ITypeDeclaration[] getTypes() {
		IBodyDeclaration[] bds = getBodyDeclarations();
		Vector out = new Vector();
		for (int i = 0; i < bds.length; i++) {
			if (bds[i] instanceof ITypeDeclaration) {
				out.add(bds[i]);
			}
		}
		return (ITypeDeclaration[]) out.toArray(
			new ITypeDeclaration[out.size()]);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration#isPackageMemberTypeDeclaration()
	 */
	public boolean isPackageMemberTypeDeclaration() {
		return !(td instanceof InnerTypeDeclaration);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration#isMemberTypeDeclaration()
	 */
	public boolean isMemberTypeDeclaration() {
		return td instanceof MemberTypeDeclaration;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration#isLocalTypeDeclaration()
	 */
	public boolean isLocalTypeDeclaration() {
		return td instanceof LocalTypeDeclaration;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration#resolveBinding()
	 */
	public IReferenceTypeBinding resolveBinding() {
		return BindingFactory.getReferenceTypeBinding(
			td.binding);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBodyDeclaration#getJavadoc()
	 */
	public IJavadoc getJavadoc() {
		if (javadoc == null) {
			javadoc = source.getJavadoc(td.declarationSourceStart);
		}
		return javadoc;
	}

	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			getName().traverse(visitor);
			IName superclass = getSuperclass();
			if (superclass != null)
				superclass.traverse(visitor);
			IName[] superinterfaces = getSuperInterfaces();
			for (int i = 0; i < superinterfaces.length; i++) {
				superinterfaces[i].traverse(visitor);
			}

			IBodyDeclaration[] bodyDeclarations = getBodyDeclarations();
			for (int i = 0; i < bodyDeclarations.length; i++) {
				bodyDeclarations[i].traverse(visitor);
			}

		}
		visitor.endVisit(this);
	}
	
	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment[] getComments() {
		if (comments == null) {
			comments = source.getBlockComment(td.sourceEnd + 1);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment = source.getEndOfLineComment(td.bodyStart);
      commentParsed = true;
		}
		return endOfLineComment;
	}
	
 

}
