/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/TryStatement.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.jdt.internal.compiler.ast.Argument;

import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.ITryStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class TryStatement implements ITryStatement {

	private org.eclipse.jdt.internal.compiler.ast.TryStatement ts;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IBlock body;
	private List catchClauses;
	private IBlock finalBlock;
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed = false;
	
	public TryStatement(
		org.eclipse.jdt.internal.compiler.ast.TryStatement ts,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.ts = ts;
		this.scope = scope;
		this.source = source;
	}
	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.TRY_STATEMENT;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITryStatement#getBody()
	 */
	public IBlock getBody() {
		if (body == null) {
			body = new Block(ts.tryBlock, source);
		}
		return body;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITryStatement#catchClauses()
	 */
	public List catchClauses() {
		if (catchClauses == null) {
			catchClauses = new Vector();
			Argument[] arguments = ts.catchArguments;
			org.eclipse.jdt.internal.compiler.ast.Block[] blocks =
				ts.catchBlocks;
			if (arguments != null) {
				for (int i = 0; i < arguments.length; i++) {
					catchClauses.add(
						new CatchClause(
							arguments[i],
							blocks[i],
							scope,
							source));
				}
			}

		}
		return catchClauses;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITryStatement#getFinally()
	 */
	public IBlock getFinally() {
		if (ts.finallyBlock == null)
			return null;
		if (finalBlock == null) {
			finalBlock = new Block(ts.finallyBlock, source);
			;
		}
		return finalBlock;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return ts.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			getBody().traverse(visitor);
			List catchArguments = catchClauses();
			if (catchArguments != null) {
				Iterator iterator = catchArguments.iterator();
				while (iterator.hasNext())
					 ((Traversable) iterator.next()).traverse(visitor);
			}

			IBlock finallyBlock = getFinally();
			if (finallyBlock != null)
				finallyBlock.traverse(visitor);
		}
		visitor.endVisit(this);
	}
	
	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment[] getComments() {
		if (comments == null) {
			comments = source.getBlockComment(ts.sourceEnd + 1);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment = source.getEndOfLineComment(ts.sourceEnd + 1);
      commentParsed = true;
		}
		return endOfLineComment;
	}
	
}
