/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/SwitchCaseFromDefault.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;

public class SwitchCaseFromDefault extends SwitchCase {

	private org.eclipse.jdt.internal.compiler.ast.DefaultCase dc;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed = false;

	public SwitchCaseFromDefault(
		org.eclipse.jdt.internal.compiler.ast.DefaultCase dc,
		BlockScope scope,
		SourceContent source) {
		this.source = source;
		this.scope = scope;
		this.dc = dc;
	}
	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ISwitchCase#getExpression()
	 */
	public IExpression getExpression() {
		return null;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ISwitchCase#isDefault()
	 */
	public boolean isDefault() {
		return true;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return dc.sourceStart;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment[] getComments() {
		if (comments == null) {
			comments = source.getBlockComment(dc.sourceEnd + 1);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment = source.getEndOfLineComment(dc.sourceEnd + 1);
      commentParsed = true;
		}
		return endOfLineComment;
	}

}
