/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/SwitchCaseFromCase.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;

public class SwitchCaseFromCase extends SwitchCase {

	private org.eclipse.jdt.internal.compiler.ast.Case cs;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IExpression expr;
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed = false;

	public SwitchCaseFromCase(
		org.eclipse.jdt.internal.compiler.ast.Case cs,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.cs = cs;
		this.scope = scope;
		this.source = source;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ISwitchCase#getExpression()
	 */
	public IExpression getExpression() {
		if (expr == null) {
			expr = Wrapper.wrapExpression(cs.constantExpression, scope, source);
		}
		return expr;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ISwitchCase#isDefault()
	 */
	public boolean isDefault() {
		return false;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return cs.sourceStart;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment[] getComments() {
		if (comments == null) {
			comments = source.getBlockComment(cs.sourceEnd + 1);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment = source.getEndOfLineComment(cs.sourceEnd + 1);
      commentParsed = true;
		}
		return endOfLineComment;
	}

}
