/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/SuperMethodInvocation.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;

import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IType;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class SuperMethodInvocation implements ISuperMethodInvocation {

	private org.eclipse.jdt.internal.compiler.ast.MessageSend mi;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private List args;
	private IType qualifier;

	public SuperMethodInvocation(
		org.eclipse.jdt.internal.compiler.ast.MessageSend mi,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.mi = mi;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.SUPER_METHOD_INVOCATION;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ISuperMethodInvocation#getName()
	 */
	public String getName() {
		return new String(mi.selector);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ISuperMethodInvocation#arguments()
	 */
	public List arguments() {
		if (args == null) {
			args = new Vector();
			org.eclipse.jdt.internal.compiler.ast.Expression[] arguments =
				mi.arguments;
			if (arguments != null) {
				for (int i = 0; i < arguments.length; i++) {
					args.add(
						Wrapper.wrapExpression(arguments[i], scope, source));
				}
			}
		}
		return args;
	}

	public IMethodBinding resolveMethodBinding() {
		org.eclipse.jdt.internal.compiler.lookup.MethodBinding mb = mi.binding;
		if (mb == null)
			return null;
		return new MethodBinding(mb);

	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		return BindingFactory.getTypeBinding(mi.binding.returnType);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return mi.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {

		if (visitor.visit(this)) {
			if (getQualifier() != null) {
				getQualifier().traverse(visitor);
			}
			List arguments = arguments();
			if (arguments != null) {
				Iterator iterator = arguments.iterator();
				while (iterator.hasNext())
					 ((Traversable) iterator.next()).traverse(visitor);
			}
		}
		visitor.endVisit(this);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IThisExpression#getQualifier()
	 */
	public IType getQualifier() {
		if (qualifier == null && mi.receiver instanceof QualifiedSuperReference) {
			qualifier = new SimpleTypeFromTypeReference(
				((QualifiedSuperReference) mi.receiver).qualification);
		}
		return qualifier;
	}

}
