/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/SuperExpression.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;

import com.sap.tc.jtools.jlint.jom.interfaces.ISuperExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IType;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class SuperExpression implements ISuperExpression {

	private org.eclipse.jdt.internal.compiler.ast.ThisReference tr;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;

	/* cache */
	private IType qualifier;
	
	public SuperExpression(
		org.eclipse.jdt.internal.compiler.ast.ThisReference tr,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope) {
		this.tr = tr;
		this.scope = scope;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.SUPER_EXPRESSION;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IThisExpression#getQualifier()
	 */
	public IType getQualifier() {
		if ( qualifier == null && tr instanceof QualifiedSuperReference) {
			qualifier = new SimpleTypeFromTypeReference(
			((QualifiedSuperReference) tr).qualification);
		}
		return qualifier;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		return BindingFactory.getTypeBinding(tr.resolveType(scope));
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return tr.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			IType qualifier = getQualifier();
			if (qualifier != null)
				qualifier.traverse(visitor);
		}
		visitor.endVisit(this);
	}

}
