/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/SuperConstructorInvocation.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperConstructorInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class SuperConstructorInvocation
	implements ISuperConstructorInvocation {

	private ExplicitConstructorCall cc;
	private BlockScope scope;
	private SourceContent source;

	/* cache */
	private IExpression expr;
	private List args;
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed = false;

	public SuperConstructorInvocation(
		ExplicitConstructorCall cc,
		BlockScope scope,
		SourceContent source) {
		this.cc = cc;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.SUPER_CONSTRUCTOR_INVOCATION;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ISuperConstructorInvocation#getExpression()
	 */
	public IExpression getExpression() {
		if (expr == null) {
			expr = Wrapper.wrapExpression(cc.qualification, scope, source);
		}
		return expr;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ISuperConstructorInvocation#arguments()
	 */
	public List arguments() {
		if (args == null) {
			args = new Vector();
			org.eclipse.jdt.internal.compiler.ast.Expression[] arguments =
				cc.arguments;
			if (arguments != null) {
				for (int i = 0; i < arguments.length; i++) {
					args.add(
						Wrapper.wrapExpression(arguments[i], scope, source));
				}
			}
		}
		return args;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ISuperConstructorInvocation#resolveConstructorBinding()
	 */
	public IMethodBinding resolveConstructorBinding() {
		org.eclipse.jdt.internal.compiler.lookup.MethodBinding binding =
			cc.binding;
		if (binding == null)
			return null;
		return new MethodBinding(binding);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return cc.sourceStart;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment[] getComments() {
		if (comments == null) {
			comments = source.getBlockComment(cc.sourceEnd + 1);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment = source.getEndOfLineComment(cc.sourceEnd + 1);
      commentParsed = true;
		}
		return endOfLineComment;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			IExpression expression = getExpression();
			if (expression != null)
				expression.traverse(visitor);
			List arguments = arguments();
			if (arguments != null) {
				Iterator iterator = arguments.iterator();
				while (iterator.hasNext())
					 ((Traversable) iterator.next()).traverse(visitor);
			}
		}
		visitor.endVisit(this);
	}

}
