/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/SourceContent.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import java.util.ArrayList;
import java.util.List;

import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IJavadoc;

/**
 * @author d034036
 */
public class SourceContent {

  private char[] src;
  private int[] lineSeparators;

  public SourceContent(char[] src, int[] lineSeparators) {
    this.src = src;
    this.lineSeparators = lineSeparators;
  }

  public IComment getEndOfLineComment(int initialPosition) {
    int lineEnd = lineEnd(initialPosition);
    int currentIndex = initialPosition;
    for (; currentIndex < lineEnd; currentIndex++) {
      if (src[currentIndex] == '/' && src[currentIndex + 1] == '/') {
        return new Comment(
          Comment.END_OF_LINE_COMMENT,
          new String(src, currentIndex, lineEnd - currentIndex - 1),
          currentIndex);
      }
    }
    // continue search in next line(s)
    while (Character.isWhitespace(src[currentIndex])) {
      currentIndex++;
    }
    if (src[currentIndex] == '/' && src[currentIndex + 1] == '/') {
      return new Comment(
        Comment.END_OF_LINE_COMMENT,
        new String(src, currentIndex, lineEnd(currentIndex) - currentIndex - 1),
        currentIndex);
    } else {
      return null;
    }
  }

  // initial position: last code character 
  public IComment[] getBlockComment(int initialPosition) {
    List comments = new ArrayList();
    int start = -1;
    int currentPosition = initialPosition + 1;
    while (true) {
      while (Character.isWhitespace(src[currentPosition]))
        currentPosition++;
      if (src[currentPosition] == '/' && src[currentPosition + 1] == '*') {
        start = currentPosition;
        currentPosition += 2;
        for (;; currentPosition++) {
          if (src[currentPosition] == '*' && src[currentPosition + 1] == '/') {
            comments.add(
              new Comment(
                Comment.BLOCK_COMMENT,
                new String(src, start, currentPosition + 2 - start),
                start));
            currentPosition += 2;
            break;
          }
        }
      } else {
        return (IComment[]) comments.toArray(new IComment[comments.size()]);
      }
    }
  }
  public IJavadoc getJavadoc(int initialPosition) {

    int start = -1;
    int currentPosition = initialPosition;
    while (Character.isWhitespace(src[currentPosition++]));
    if (src[currentPosition - 1] == '/'
      && src[currentPosition] == '*'
      && src[currentPosition + 1] == '*') {
      start = currentPosition - 1;
      currentPosition += 2;
      for (;; currentPosition++) {
        if (src[currentPosition] == '*' && src[currentPosition + 1] == '/')
          return new Javadoc(
            new String(src, start, currentPosition + 2 - start),
            start);
      }
    }
    return null;
  }

  public int lineNumber(int position) {
    if (position < 0 || position >= src.length || lineSeparators == null)
      return -1;
    for (int i = 0; i < lineSeparators.length; i++) {
      if (position < lineSeparators[i] + 1) {
        return i + 1;
      }
    }
    return lineSeparators.length + 1;
  }

  public int columnNumber(int position) {
    if (position < 0 || position >= src.length || lineSeparators == null)
      return -1;
    int currentOffset = 0;
    for (int i = 0; i < lineSeparators.length; i++) {
      if (position < lineSeparators[i] + 1) {
        return position - currentOffset + 1;
      }
      currentOffset = lineSeparators[i] + 1;
    }
    return position - currentOffset + 1;
  }

  private int lineEnd(int startPos) {
    if (startPos < 0 || startPos >= src.length || lineSeparators == null)
      return -1;
    if (lineSeparators.length == 0)
      return src.length - 1;
    for (int i = 0; i < lineSeparators.length; i++) {
      if (lineSeparators[i] >= startPos)
        return lineSeparators[i];
    }
    return -1;
  }

  public int getLineCount() {
    return lineSeparators == null ? 1 : lineSeparators.length + 1;
  }
}
