/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/SingleVariableDeclaration.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IType;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class SingleVariableDeclaration implements IVariableDeclaration {

	private org.eclipse.jdt.internal.compiler.ast.LocalDeclaration vd;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IType type;

	public SingleVariableDeclaration(
		org.eclipse.jdt.internal.compiler.ast.LocalDeclaration vd,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.vd = vd;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.VARIABLE_DECLARATION;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ISingleVariableDeclaration#getModifiers()
	 */
	public int getModifiers() {
		return vd.modifiers;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ISingleVariableDeclaration#getType()
	 */
	public IType getType() {
		if (type == null) {
			TypeReference tr = vd.type;
			if (tr.dimensions() == 0) {
				type = new SimpleTypeFromTypeReference(tr);
			} else {
				if (tr instanceof ArrayTypeReference) {
					type =
						new ArrayTypeFromTypeReference((ArrayTypeReference) tr);
				} else if (tr instanceof ArrayQualifiedTypeReference) {
					type =
						new ArrayTypeFromTypeReference(
							(ArrayQualifiedTypeReference) tr);
				}
			}
		}
		return type;

	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration#getName()
	 */
	public String getName() {
		return new String(vd.name);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration#resolveBinding()
	 */
	public IVariableBinding resolveBinding() {
		return new VariableBinding(vd.binding);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return vd.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			getType().traverse(visitor);
		}
		visitor.endVisit(this);
	}

}
