/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/SimpleTypeFromTypeReference.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;

public class SimpleTypeFromTypeReference extends SimpleType {

	private org.eclipse.jdt.internal.compiler.ast.TypeReference st;

	public SimpleTypeFromTypeReference(
		org.eclipse.jdt.internal.compiler.ast.TypeReference st) {
		this.st = st;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ISimpleType#getName()
	 */
	public String[] getName() {
		char[][] name = st.getTypeName();
		String[] out = new String[name.length];
		for (int i = 0; i < name.length; i++)
			out[i] = new String(name[i]);
		return out;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IType#isPrimitiveType()
	 */
	public boolean isPrimitiveType() {
		char[][] tokens = st.getTypeName();
		if (tokens.length != 1)
			return false;
		String name = new String(tokens[0]);
		return (name.equals("void") //$NON-NLS-1$
		|| name.equals("int") //$NON-NLS-1$
		|| name.equals("char") //$NON-NLS-1$
		|| name.equals("boolean") //$NON-NLS-1$
		|| name.equals("short") //$NON-NLS-1$
		|| name.equals("long") //$NON-NLS-1$
		|| name.equals("float") //$NON-NLS-1$
		|| name.equals("double") //$NON-NLS-1$
		|| name.equals("byte")); //$NON-NLS-1$
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IType#resolveBinding()
	 */
	public ITypeBinding resolveBinding() {
		org.eclipse.jdt.internal.compiler.lookup.TypeBinding tb = st.resolvedType;
		if (tb == null)
			return null;
		return BindingFactory.getTypeBinding(tb);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return st.sourceStart;
	}

}
