/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/SimpleTypeFromNameReference.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;


import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;

public class SimpleTypeFromNameReference extends SimpleType {

	private NameReference nr;

	public SimpleTypeFromNameReference(SingleNameReference nr) {
		this.nr = nr;
	}
	
	public SimpleTypeFromNameReference(QualifiedNameReference nr) {
		this.nr = nr;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ISimpleType#getName()
	 */
	public String[] getName() {
		if (nr	instanceof SingleNameReference) {
			return new String[] {new String(((SingleNameReference) nr).token)};
	    } else {
			char[][] tokens = ((QualifiedNameReference) nr).tokens;
			String[] out = new String[tokens.length];
			for (int i = 0; i < tokens.length; i++) {
				out[i] = new String(tokens[i]);
			}
			return out;
		}
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IType#isPrimitiveType()
	 */
	public boolean isPrimitiveType() {
		return ((org.eclipse.jdt.internal.compiler.lookup.TypeBinding)nr.binding).isBaseType();
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IType#resolveBinding()
	 */
	public ITypeBinding resolveBinding() {
		if (nr	instanceof SingleNameReference) {
			return BindingFactory.getTypeBinding(
				(org.eclipse.jdt.internal.compiler.lookup.TypeBinding)
					((SingleNameReference) nr).binding);
		} else { 
			return BindingFactory.getTypeBinding(
				(org.eclipse.jdt.internal.compiler.lookup.TypeBinding)
					((QualifiedNameReference) nr).binding);
		}
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return nr.sourceStart;
	}

}
