/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/SimpleNameFromTypeReference.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;

public class SimpleNameFromTypeReference extends SimpleName {

	private org.eclipse.jdt.internal.compiler.ast.TypeReference tr;

	public SimpleNameFromTypeReference(
		org.eclipse.jdt.internal.compiler.ast.TypeReference tr) {
		this.tr = tr;
	}

	public int getStartPosition() {
		return tr.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName#getIdentifier()
	 */
	public String getIdentifier() {
		char[][] tokens = tr.getTypeName();
		return new String(tokens[tokens.length - 1]);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IName#resolveBinding()
	 */
	public IBinding resolveBinding() {
		return BindingFactory.getTypeBinding(tr.resolvedType);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		return BindingFactory.getTypeBinding(tr.resolvedType);
	}

}
