/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/SimpleNameFromString.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;

public class SimpleNameFromString extends SimpleName {

	private String name;
	private IBinding binding;
	private int position = -1;

	public SimpleNameFromString(String name, int position, IBinding binding) {
		this.name = name;
		this.position = position;
		this.binding = binding;
	}

	public int getStartPosition() {
		return position;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName#getIdentifier()
	 */
	public String getIdentifier() {
		return name;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IName#resolveBinding()
	 */
	public IBinding resolveBinding() {
		return binding;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		if ( binding instanceof ITypeBinding )
		    return (ITypeBinding)binding;
		if ( binding instanceof IVariableBinding )
			return ((IVariableBinding)binding).getType();
		return null;		  
	}

}
