/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/SimpleNameFromSingleNameReference.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;

public class SimpleNameFromSingleNameReference extends SimpleName {

	private org.eclipse.jdt.internal.compiler.ast.SingleNameReference sn;

	public SimpleNameFromSingleNameReference(
		org.eclipse.jdt.internal.compiler.ast.SingleNameReference sn) {
		this.sn = sn;
	}

	public int getStartPosition() {
		return sn.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName#getIdentifier()
	 */
	public String getIdentifier() {
		return new String(sn.token);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IName#resolveBinding()
	 */
	public IBinding resolveBinding() {
		org.eclipse.jdt.internal.compiler.lookup.Binding binding = sn.binding;
		if (binding == null)
			return null;
		if (binding
			instanceof org.eclipse.jdt.internal.compiler.lookup.TypeBinding)
			return BindingFactory.getTypeBinding(
				(org.eclipse.jdt.internal.compiler.lookup.TypeBinding) binding);
		if (binding
			instanceof org.eclipse.jdt.internal.compiler.lookup.VariableBinding)
			return new VariableBinding(
				(org
					.eclipse
					.jdt
					.internal
					.compiler
					.lookup
					.VariableBinding) binding);
		if (binding
			instanceof org.eclipse.jdt.internal.compiler.lookup.ImportBinding)
			return new PackageBindingFromImportBinding(
				(org
					.eclipse
					.jdt
					.internal
					.compiler
					.lookup
					.ImportBinding) binding);
		if (binding
			instanceof org.eclipse.jdt.internal.compiler.lookup.PackageBinding)
			return BindingFactory.getPackageBinding(
				(org
					.eclipse
					.jdt
					.internal
					.compiler
					.lookup
					.PackageBinding) binding);

		return null;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {

		org.eclipse.jdt.internal.compiler.lookup.Binding binding = sn.binding;

		if (binding != null) {
			if (binding
				instanceof org.eclipse.jdt.internal.compiler.lookup.TypeBinding)
				return BindingFactory.getTypeBinding(
					(org
						.eclipse
						.jdt
						.internal
						.compiler
						.lookup
						.TypeBinding) binding);
			if (binding
				instanceof org.eclipse.jdt.internal.compiler.lookup.VariableBinding)
				return new VariableBinding(
					(org
						.eclipse
						.jdt
						.internal
						.compiler
						.lookup
						.VariableBinding) binding)
					.getType();
		}
		return null;
	}

}
