/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/SimpleNameFromQualifiedNameReference.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.lookup.Binding;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;

public class SimpleNameFromQualifiedNameReference extends SimpleName {

  private org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference qn;

  public SimpleNameFromQualifiedNameReference(
    org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference qn) {
    this.qn = qn;
  }

  public int getStartPosition() {
    return qn.sourceStart;
  }

  /**
   * @see com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName#getIdentifier()
   */
  public String getIdentifier() {
    return new String(qn.tokens[0]);
  }

  /**
   * @see com.sap.tc.jtools.jlint.jom.interfaces.IName#resolveBinding()
   */
  public IBinding resolveBinding() {
    //	org.eclipse.jdt.internal.compiler.lookup.FieldBinding[] otherBindings =
    //		qn.otherBindings;
    //	Binding bnd = qn.binding;
    Binding bnd = qn.actualReceiverType;
    if (bnd instanceof org.eclipse.jdt.internal.compiler.lookup.TypeBinding)
      return BindingFactory.getTypeBinding(
        (org.eclipse.jdt.internal.compiler.lookup.TypeBinding) bnd);
    if (bnd instanceof org.eclipse.jdt.internal.compiler.lookup.ImportBinding)
      return new PackageBindingFromImportBinding(
        (org.eclipse.jdt.internal.compiler.lookup.ImportBinding) bnd);
    if (bnd instanceof org.eclipse.jdt.internal.compiler.lookup.PackageBinding)
      return BindingFactory.getPackageBinding(
        (org.eclipse.jdt.internal.compiler.lookup.PackageBinding) bnd);
    if (bnd
      instanceof org.eclipse.jdt.internal.compiler.lookup.VariableBinding)
      return new VariableBinding(
        (org.eclipse.jdt.internal.compiler.lookup.VariableBinding) bnd);
    return null;
  }

  /**
   * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
   */
  public ITypeBinding resolveTypeBinding() {

    org.eclipse.jdt.internal.compiler.lookup.Binding binding =
      qn.actualReceiverType;
    if (binding
      instanceof org.eclipse.jdt.internal.compiler.lookup.TypeBinding)
      return BindingFactory.getTypeBinding(
        (org.eclipse.jdt.internal.compiler.lookup.TypeBinding) binding);
    if (binding
      instanceof org.eclipse.jdt.internal.compiler.lookup.VariableBinding)
      return new VariableBinding(
        (org.eclipse.jdt.internal.compiler.lookup.VariableBinding) binding)
        .getType();
    return null;
  }

}
