/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/QualifiedNameFromTypeReference.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IQualifier;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;

public class QualifiedNameFromTypeReference extends QualifiedName {

	private org.eclipse.jdt.internal.compiler.ast.TypeReference tr;

	/* cache */
	private IQualifier qual;

	public QualifiedNameFromTypeReference(
		org.eclipse.jdt.internal.compiler.ast.TypeReference tr) {
		this.tr = tr;
	}

	public int getStartPosition() {
		return tr.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName#getQualifier()
	 */
	public IQualifier getQualifier() {
		if (qual == null) {
			ITypeBinding binding = resolveTypeBinding();
			String[] components = getNameComponents();
			IBinding qualifierBinding = null;

			ReferenceTypeBinding outerClass =
				(ReferenceTypeBinding) ((ReferenceTypeBinding) binding)
					.getDeclaringClass();

			if (outerClass != null) {
				if (components.length == 2) {
					qual =
						new SimpleNameFromString(
							components[0],
							getStartPosition(),
							outerClass);
				} else {
					qual =
						new QualifiedNameFromTypeBinding(
							outerClass,
							getStartPosition());
				}
			} else {
				String[] qualifierComponents =
					new String[components.length - 1];
				for (int i = 0; i < qualifierComponents.length; i++) {
					qualifierComponents[i] = components[i];
				}
				qual =
					new PackageNameFromStrings(
						qualifierComponents,
						getStartPosition());
			}
		}
		return qual;

	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName#getName()
	 */
	public String getName() {
		char[][] tokens = tr.getTypeName();
		return new String(tokens[tokens.length - 1]);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName#getNameComponents()
	 */
	public String[] getNameComponents() {
		char[][] tokens = tr.getTypeName();
		String[] out = new String[tokens.length];
		for (int i = 0; i < out.length; i++) {
			out[i] = new String(tokens[i]);
		}
		return out;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IName#resolveBinding()
	 */
	public IBinding resolveBinding() {
		return BindingFactory.getTypeBinding(tr.resolvedType);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		return BindingFactory.getTypeBinding(tr.resolvedType);
	}

}
