/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/QualifiedNameFromTypeBinding.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import java.util.Vector;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IQualifier;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;

public class QualifiedNameFromTypeBinding extends QualifiedName {

	private ReferenceTypeBinding tb;
	private int position;

	/* cache */
	private IQualifier qual;

	public QualifiedNameFromTypeBinding(
		ReferenceTypeBinding tb,
		int position) {
		this.tb = tb;
		this.position = position;
	}

	public int getStartPosition() {
		return position;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName#getQualifier()
	 */
	public IQualifier getQualifier() {
		if (qual == null) {
			String[] components = getNameComponents();
			IBinding qualifierBinding = null;

			ReferenceTypeBinding outerClass =
				(ReferenceTypeBinding) tb.getDeclaringClass();

			if (outerClass != null) {
				if (components.length == 2) {
					qual =
						new SimpleNameFromString(
							components[0],
							getStartPosition(),
							outerClass);
				} else {
					qual =
						new QualifiedNameFromTypeBinding(
							outerClass,
							getStartPosition());
				}
			} else {
				String[] qualifierComponents =
					new String[components.length - 1];
				for (int i = 0; i < qualifierComponents.length; i++) {
					qualifierComponents[i] = components[i];
				}
				qual =
					new PackageNameFromStrings(
						qualifierComponents,
						getStartPosition());
			}
		}
		return qual;

	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName#getName()
	 */
	public String getName() {
		return tb.getName();
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName#getNameComponents()
	 */
	public String[] getNameComponents() {
		Vector nameComponents = new Vector();

		int index = 0;
		IPackageBinding pack = tb.getPackage();
		if (pack != null) {
			String[] packNameComponents = pack.getNameComponents();
			for (int i = 0; i < packNameComponents.length; i++) {
				nameComponents.insertElementAt(packNameComponents[i], i);
			}
			index = packNameComponents.length;
		}

		IReferenceTypeBinding currentClass = tb;
		while (currentClass.getDeclaringClass() != null) {
			nameComponents.insertElementAt(
				currentClass.getDeclaringClass().getName(),
				index);
			currentClass = currentClass.getDeclaringClass();
		}

		nameComponents.add(tb.getName());
		return (String[]) nameComponents.toArray(
			new String[nameComponents.size()]);

	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IName#resolveBinding()
	 */
	public IBinding resolveBinding() {
		return tb;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		return tb;
	}

}
