/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/QualifiedNameFromQualifiedNameReference.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IQualifier;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;

public class QualifiedNameFromQualifiedNameReference extends QualifiedName {

	private org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference qn;
	private int index;
	private IBinding binding;

	/* cache */
	private IQualifier qual;

	public QualifiedNameFromQualifiedNameReference(
		org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference qn) {
		this.qn = qn;
		this.index = qn.tokens.length - 1;
	}

	public QualifiedNameFromQualifiedNameReference(
		org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference qn,
		int index,
		IBinding binding) {
		this(qn);
		this.index = index;
		this.binding = binding;
	}

	public int getStartPosition() {
		return qn.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName#getQualifier()
	 */
	public IQualifier getQualifier() {
		if (qual == null) {
			IBinding qualifierBinding = getQualifierBinding();
			if (qualifierBinding instanceof IPackageBinding) {
				qual = new PackageName(qn, index - 1);
			} else if (index == 1) {
				char[][] qualifier = qn.tokens;
				qual =
					new SimpleNameFromString(
						new String(qualifier[0]),
						getStartPosition(),
						(ITypeBinding) qualifierBinding);
			} else {
				qual =
					new QualifiedNameFromQualifiedNameReference(
						qn,
						index - 1,
						getQualifierBinding());
			}
		}
		return qual;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName#getName()
	 */
	public String getName() {
		char[][] tokens = qn.tokens;
		return new String(tokens[index]);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IName#resolveBinding()
	 */
	public IBinding resolveBinding() {
		if (binding != null)
			return binding;

		Binding qualifiedNameBinding = qn.binding;
		if (qn.otherBindings != null
			&& qn.otherBindings.length + index + 1 - qn.tokens.length > 0) {
			qualifiedNameBinding =
				qn.otherBindings[qn.otherBindings.length
					- 1
					+ index
					+ 1
					- qn.tokens.length];
		}
		switch (qualifiedNameBinding.bindingType()) {
			case Binding.TYPE :
				return BindingFactory.getReferenceTypeBinding(
					(ReferenceBinding) qualifiedNameBinding);
			case Binding.FIELD :
				return new VariableBinding((FieldBinding) qualifiedNameBinding);
			default :
				throw new IllegalArgumentException(
					"wrong binding type: "
						+ qualifiedNameBinding.bindingType());
		}
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {

		IBinding binding = resolveBinding();
		switch (binding.getKind()) {
			case IBinding.VARIABLE :
				return ((VariableBinding) binding).getType();
			case IBinding.TYPE :
				return (ITypeBinding) binding;
			default :
				return null;
		}
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName#getNameComponents()
	 */
	public String[] getNameComponents() {
		char[][] tokens = qn.tokens;
		//		int offset =
		//			(qn.otherBindings == null) ? 1 : qn.otherBindings.length + 1;
		String[] out = new String[index + 1];
		for (int i = 0; i <= index; i++) {
			out[i] = new String(tokens[i]);
		}
		return out;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IName#isPackageName()
	 */
	public boolean isPackageName() {
		return false;
	}

	private IBinding getQualifierBinding() {
		Binding qualifierBinding = qn.binding;
		if (qn.otherBindings != null
			&& qn.otherBindings.length + index - qn.tokens.length > 0) {
			qualifierBinding =
				qn.otherBindings[qn.otherBindings.length
					- 1
					+ index
					- qn.tokens.length];
			switch (qualifierBinding.bindingType()) {
				case Binding.TYPE :
					return BindingFactory.getReferenceTypeBinding(
						(ReferenceBinding) qualifierBinding);
				case Binding.FIELD :
					return new VariableBinding((FieldBinding) qualifierBinding);
				default :
					throw new IllegalArgumentException(
						"wrong binding type: "
							+ qualifierBinding.bindingType());
			}
		}

		if (index == qn.tokens.length - 1
			&& qn.otherBindings != null
			&& qn.otherBindings.length == 1) {
			qualifierBinding = qn.binding;
			switch (qualifierBinding.bindingType()) {
				case Binding.TYPE :
					return BindingFactory.getTypeBinding(
						(ReferenceBinding) qualifierBinding);
				case Binding.FIELD :
					return new VariableBinding((FieldBinding) qualifierBinding);
				default :
					throw new IllegalArgumentException(
						"wrong binding type: "
							+ qualifierBinding.bindingType());
			}

		}

		IBinding qualifiedBinding = resolveBinding();

		switch (qualifiedBinding.getKind()) {
			case IBinding.TYPE :
				ITypeBinding outerClass =
					((ReferenceTypeBinding) qualifiedBinding)
						.getDeclaringClass();
				if (outerClass != null) {
					return outerClass;
				} else {
					return ((ReferenceTypeBinding) qualifiedBinding)
						.getPackage();
				}
			case IBinding.VARIABLE :
				return ((VariableBinding) qualifiedBinding).getDeclaringClass();
			default :
				return null;
		}

	}

}
