/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/PrimitiveTypeBinding.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IPrimitiveTypeBinding;

public class PrimitiveTypeBinding implements IPrimitiveTypeBinding {

	private org.eclipse.jdt.internal.compiler.lookup.TypeBinding binding;

	public PrimitiveTypeBinding(
		org.eclipse.jdt.internal.compiler.lookup.TypeBinding binding) {
		this.binding = binding;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding#isPrimitive()
	 */
	public boolean isPrimitive() {
		return true;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding#isArray()
	 */
	public boolean isArray() {
		return false;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#getName()
	 */
	public String getName() {
		return new String(binding.sourceName());
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#getKind()
	 */
	public int getKind() {
		return IBinding.TYPE;
	}

 

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#equals(com.sap.tc.jtools.jlint.jom.interfaces.IBinding)
	 */
	public boolean equals(Object object) {
		return (object instanceof PrimitiveTypeBinding)
			&& (((PrimitiveTypeBinding) object).binding.equals(this.binding));
	}

  public int hashCode() {
    return binding.hashCode();
  }

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding#isNullType()
	 */
	public boolean isNullType() {
		return binding == BaseTypes.NullBinding;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding#isReference()
	 */
	public boolean isReference() {
		return false;
	}

}
