/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/PrefixExpressionFromUnaryExpression.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;

public class PrefixExpressionFromUnaryExpression extends PrefixExpression {

	private org.eclipse.jdt.internal.compiler.ast.UnaryExpression ue;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IExpression expr;
	
	public PrefixExpressionFromUnaryExpression(
		org.eclipse.jdt.internal.compiler.ast.UnaryExpression ue,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.ue = ue;
		this.scope = scope;
		this.source = source;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IPostfixExpression#getOperator()
	 */
	public String getOperator() {
		return ue.operatorToString();
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IPostfixExpression#getOperand()
	 */
	public IExpression getOperand() {
		if ( expr == null )  {
			expr = Wrapper.wrapExpression(ue.expression, scope, source);
		}
		return expr;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return ue.sourceStart;
	}

}
