/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/PrefixExpressionFromPrefixExpression.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;

public class PrefixExpressionFromPrefixExpression extends PrefixExpression {

	private org.eclipse.jdt.internal.compiler.ast.PrefixExpression pe;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IExpression expr;
	
	public PrefixExpressionFromPrefixExpression(
		org.eclipse.jdt.internal.compiler.ast.PrefixExpression pe,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope) {
		this.pe = pe;
		this.scope = scope;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IPostfixExpression#getOperator()
	 */
	public String getOperator() {
		return pe.operatorToString();
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IPostfixExpression#getOperand()
	 */
	public IExpression getOperand() {
		if ( expr == null )  {
			expr = Wrapper.wrapExpression(pe.lhs, scope, source);
		}
		return expr;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return pe.sourceStart;
	}

}
