/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/PostfixExpression.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IPostfixExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class PostfixExpression implements IPostfixExpression {

	private org.eclipse.jdt.internal.compiler.ast.PostfixExpression pe;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IExpression expr;
	
	public PostfixExpression(
		org.eclipse.jdt.internal.compiler.ast.PostfixExpression pe,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope) {
		this.pe = pe;
		this.scope = scope;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.POSTFIX_EXPRESSION;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IPostfixExpression#getOperator()
	 */
	public String getOperator() {
		return pe.operatorToString();
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IPostfixExpression#getOperand()
	 */
	public IExpression getOperand() {
		if ( expr == null ) {
			expr = Wrapper.wrapExpression(pe.lhs, scope, source);
		}
		return expr;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		return getOperand().resolveTypeBinding();
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return pe.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			getOperand().traverse(visitor);
		}
		visitor.endVisit(this);
	}

}
