/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/PackageNameFromStrings.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageName;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;

public class PackageNameFromStrings implements IPackageName {

	private String[] components;
	private int startPosition;
	
	public PackageNameFromStrings(String[] components, int startPosition) {
		this.components = components;
		this.startPosition = startPosition;
	}

	public int getStartPosition() {
		return startPosition;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IName#resolveBinding()
	 */
	public IBinding resolveBinding() {
        return new PackageBindingFromStringArray(components);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName#getNameComponents()
	 */
	public String[] getNameComponents() {
		return components;
	}

 

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(com.sap.tc.jtools.jlint.jom.interfaces.IVisitor)
	 */
	public void traverse(IVisitor visitor) {
		visitor.visit(this);
		visitor.endVisit(this);
		
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.PACKAGE_NAME;
	}

}
