/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/PackageDeclaration.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class PackageDeclaration implements IPackageDeclaration {

	private org.eclipse.jdt.internal.compiler.ast.ImportReference ir;

	public PackageDeclaration(
		org.eclipse.jdt.internal.compiler.ast.ImportReference ir) {
		this.ir = ir;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.PACKAGE_DECLARATION;
	}

	public int getStartPosition() {
		return ir.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IPackageDeclaration#getName()
	 */
	public String[] getName() {
		char[][] tokens = ir.getImportName();
		if (tokens == null)
			return null;
		String[] out = new String[tokens.length];
		for (int i = 0; i < tokens.length; i++)
			out[i] = new String(tokens[i]);
		return out;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IPackageDeclaration#resolveBinding()
	 */
	public IPackageBinding resolveBinding() {
		char[][] tokens = ir.tokens;
		String[] components = new String[tokens.length];
		for (int i = 0; i < components.length; i++)
			components[i] = new String(tokens[i]);
		return new PackageBindingFromStringArray(components);
	}

	public void traverse(IVisitor visitor) {
		visitor.visit(this);
		visitor.endVisit(this);
	}
}
