/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/PackageBindingFromStringArray.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;


public class PackageBindingFromStringArray extends PackageBinding {

	private String[] nameComponents;
  private String name;
  

	public PackageBindingFromStringArray(String[] nameComponents) {
		this.nameComponents = nameComponents;
	}
	/** 
	 * 
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#getName()
	 */
	public String getName() {
		if (nameComponents == null)
			return null;
    if (name != null) return name;
		String nameString = EMPTY_STRING;
		for (int i = 0; i < nameComponents.length - 1; i++)
			nameString += new String(nameComponents[i]) + COMPONENT_SEPARATOR;
		nameString += new String(nameComponents[nameComponents.length - 1]);
		return name = nameString;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding#isUnnamed()
	 */
	public boolean isUnnamed() {
		return nameComponents == null;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding#getNameComponents()
	 */
	public String[] getNameComponents() {
		return nameComponents;
	}
  

}
