/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/PackageBindingFromPackageBinding.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

public class PackageBindingFromPackageBinding extends PackageBinding {

  org.eclipse.jdt.internal.compiler.lookup.PackageBinding binding;
  private String name = null;
  private String[] nameComponents = null;

  public PackageBindingFromPackageBinding(
    org.eclipse.jdt.internal.compiler.lookup.PackageBinding binding) {
    this.binding = binding;
  }

  /** 
   * 
   * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#getName()
   */
  public String getName() {
    if (binding.compoundName.length == 0) // unnamed package
      return null;
    if (name != null) {
      return name;
    } else {
      char[][] compoundName = binding.compoundName;
      StringBuffer nameBuf = new StringBuffer();
      for (int i = 0; i < compoundName.length - 1; i++)
        nameBuf.append(new String(compoundName[i]) + COMPONENT_SEPARATOR);
      nameBuf.append(new String(compoundName[compoundName.length - 1]));
      return name = nameBuf.toString();
    }
  }

  /**
   * @see com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding#isUnnamed()
   */
  public boolean isUnnamed() {
    return binding.compoundName.length == 0;
  }

  /**
   * @see com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding#getNameComponents()
   */
  public String[] getNameComponents() {
    if (nameComponents != null)
      return nameComponents;
    char[][] tokens = binding.compoundName;
    nameComponents = new String[tokens.length];
    for (int i = 0; i < nameComponents.length; i++) {
      nameComponents[i] = new String(tokens[i]);
    }
    return nameComponents;
  }

}
