/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/PackageBindingFromImportBinding.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

public class PackageBindingFromImportBinding extends PackageBinding {

  org.eclipse.jdt.internal.compiler.lookup.ImportBinding iBinding;
  private String name = null;
  private String[] nameComponents = null;

  public PackageBindingFromImportBinding(
    org.eclipse.jdt.internal.compiler.lookup.ImportBinding binding) {
    iBinding = binding;
  }

  /** 
   * 
   * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#getName()
   */
  public String getName() {
    if (name != null)
      return name;
    char[][] tokens = iBinding.compoundName;
    String nameString = EMPTY_STRING;
    for (int i = 0; i < tokens.length - 1; i++)
      nameString += new String(tokens[i]) + COMPONENT_SEPARATOR;
    nameString += new String(tokens[tokens.length - 1]);
    return name = nameString;
  }

  /**
   * @see com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding#getNameComponents()
   */
  public String[] getNameComponents() {
    if (nameComponents != null)
      return nameComponents;
    char[][] tokens = iBinding.reference.tokens;
    String[] out = new String[tokens.length];
    for (int i = 0; i < out.length; i++)
      out[i] = new String(out[i]);
    return nameComponents = out;
  }

  /**
   * @see com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding#isUnnamed()
   */
  public boolean isUnnamed() {
    return false;
  }

}
