/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/PackageBinding.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;

abstract public class PackageBinding implements IPackageBinding {

  static protected final String EMPTY_STRING = ""; //$NON-NLS-1$ 
  static protected final String COMPONENT_SEPARATOR = "."; //$NON-NLS-1$ 

  private static final int NULL_HASHCODE = 984697436;

  /**
   * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#getKind()
   */
  public int getKind() {
    return IBinding.PACKAGE;
  }

  /**
   * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#getModifiers()
   */
  public int getModifiers() {
    return 0;
  }

  /**
   * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#isDeprecated()
   */
  public boolean isDeprecated() {
    return false;
  }

  /* (non-Javadoc)
   * @see java.lang.Object#hashCode()
   */
  public int hashCode() {
    String name = getName();
    if (name == null) {
      return NULL_HASHCODE;
    } else {
      return name.hashCode();
    }
  }

  public boolean equals(Object obj) {
    if (obj instanceof PackageBinding) {
      PackageBinding pkgBnd = (PackageBinding) obj;
      if (pkgBnd.isUnnamed() || isUnnamed()) {
        // getName() == null in this case!
        return pkgBnd.isUnnamed() && isUnnamed();
      } else {
        return getName().equals(pkgBnd.getName());
      }
    }
    return false;
  }
}
