/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/NumberLiteral.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;

import com.sap.tc.jtools.jlint.jom.interfaces.INumberLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class NumberLiteral implements INumberLiteral {

	private  org.eclipse.jdt.internal.compiler.ast.NumberLiteral literal;

	public NumberLiteral(
		org.eclipse.jdt.internal.compiler.ast.NumberLiteral literal) {
		this.literal = literal;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.NUMBER_LITERAL;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.INumberLiteral#getToken()
	 */
	public String getToken() {
		return literal.toStringExpression();
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		String typeID = literal.constant.typeName();
		if (typeID.equals("int")) //$NON-NLS-1$
			return BindingFactory.getPrimitiveTypeBinding(BaseTypeBinding.IntBinding);
		if (typeID.equals("byte")) //$NON-NLS-1$
			return BindingFactory.getPrimitiveTypeBinding(BaseTypeBinding.ByteBinding);
		if (typeID.equals("short")) //$NON-NLS-1$
			return BindingFactory.getPrimitiveTypeBinding(BaseTypeBinding.ShortBinding);
		if (typeID.equals("long")) //$NON-NLS-1$
			return BindingFactory.getPrimitiveTypeBinding(BaseTypeBinding.LongBinding);
		if (typeID.equals("float")) //$NON-NLS-1$
			return BindingFactory.getPrimitiveTypeBinding(BaseTypeBinding.FloatBinding);
		if (typeID.equals("double")) //$NON-NLS-1$
			return BindingFactory.getPrimitiveTypeBinding(BaseTypeBinding.DoubleBinding);
		return null;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return literal.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		visitor.visit(this);
		visitor.endVisit(this);
	}

}
