/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/MethodInvocation.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.jdt.internal.compiler.ast.ThisReference;

import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;

public class MethodInvocation implements IMethodInvocation {

	private org.eclipse.jdt.internal.compiler.ast.MessageSend mi;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private IExpression expr;
	private List arguments;

	public MethodInvocation(
		org.eclipse.jdt.internal.compiler.ast.MessageSend mi,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.mi = mi;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.METHOD_INVOCATION;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation#getExpression()
	 */
	public IExpression getExpression() {
		if (expr == null && mi.receiver != null) {
			if (!(mi.receiver instanceof ThisReference)
				|| mi.receiver.sourceStart != 0) { // filter implicit this
				expr = Wrapper.wrapExpression(mi.receiver, scope, source);
			}
		}
		return expr;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation#getName()
	 */
	public String getName() {
		return new String(mi.selector);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation#arguments()
	 */
	public List arguments() {
		if (arguments == null) {
			arguments = new Vector();
			org.eclipse.jdt.internal.compiler.ast.Expression[] argumentArray =
				mi.arguments;
			if (argumentArray != null) {
				for (int i = 0; i < argumentArray.length; i++)
					arguments.add(
						Wrapper.wrapExpression(
							argumentArray[i],
							scope,
							source));
			}
		}
		return arguments;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IExpression#resolveTypeBinding()
	 */
	public ITypeBinding resolveTypeBinding() {
		if (mi.binding == null)
			return null;
		org.eclipse.jdt.internal.compiler.lookup.TypeBinding rt =
			mi.binding.returnType;
		if (rt == null)
			return null;
		return BindingFactory.getTypeBinding(rt);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Position#getStartPosition()
	 */
	public int getStartPosition() {
		return mi.sourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#traverse(ITestVisitor)
	 */
	public void traverse(IVisitor visitor) {
		if (visitor.visit(this)) {
			IExpression expr = getExpression();
			if (expr != null)
				expr.traverse(visitor);
			List arguments = arguments();
			if (arguments != null) {
				Iterator iterator = arguments.iterator();
				while (iterator.hasNext())
					 ((Traversable) iterator.next()).traverse(visitor);
			}
		}
		visitor.endVisit(this);
	}

	public IMethodBinding resolveMethodBinding() {
		org.eclipse.jdt.internal.compiler.lookup.MethodBinding mb = mi.binding;
		if (mb == null)
			return null;
		return new MethodBinding(mb);

	}

}
