/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/MethodDeclaration.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IJavadoc;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IType;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;

public class MethodDeclaration implements IMethodDeclaration {

	private org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration md;
	private org.eclipse.jdt.internal.compiler.lookup.BlockScope scope;
	private SourceContent source;

	/* cache */
	private List parameters;
	private List exceptions;
	private IType returnType;
	private IBlock body;
	private IJavadoc javadoc;
	private IComment[] comments;
	private IComment endOfLineComment;
  private boolean commentParsed = false;

	public MethodDeclaration(
		org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration md,
		org.eclipse.jdt.internal.compiler.lookup.BlockScope scope,
		SourceContent source) {
		this.md = md;
		this.scope = scope;
		this.source = source;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.Traversable#getNodeType()
	 */
	public int getNodeType() {
		return Traversable.METHOD_DECLARATION;
	}

	public int getStartPosition() {
		return md.declarationSourceStart;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration#isConstructor()
	 */
	public boolean isConstructor() {
		return md.isConstructor();
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration#getModifiers()
	 */
	public int getModifiers() {
		return md.modifiers;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration#getName()
	 */
	public String getName() {
		return new String(md.selector);

	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration#parameters()
	 */
	public List parameters() {
		if (parameters == null) {
			parameters = new Vector();
			Argument[] arguments = md.arguments;
			if (arguments != null) {
				for (int i = 0; i < arguments.length; i++) {
					parameters.add(
						new SingleVariableDeclaration(
							arguments[i],
							md.scope,
							source));
				}

			}
		}
		return parameters;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration#thrownExceptions()
	 */
	public List thrownExceptions() {
		if (exceptions == null) {
			md.bindThrownExceptions();
			exceptions = new Vector();
			TypeReference[] exceptionArray = md.thrownExceptions;
			if (exceptionArray != null) {
				for (int i = 0; i < exceptionArray.length; i++) {
					char[][] tokens = exceptionArray[i].getTypeName();
					if (tokens.length == 1) {
						exceptions.add(
							new SimpleNameFromTypeReference(exceptionArray[i]));
					} else {
						exceptions.add(
							new QualifiedNameFromTypeReference(exceptionArray[i]));
					}
				}
			}
		}
		return exceptions;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration#getReturnType()
	 */
	public IType getReturnType() {
		if (md.isConstructor())
			return null;
		if (returnType == null) {
			if (md
				instanceof org.eclipse.jdt.internal.compiler.ast.MethodDeclaration) {
				TypeReference tr =
					(
						(
							org
								.eclipse
								.jdt
								.internal
								.compiler
								.ast
								.MethodDeclaration) md)
								.returnType;

				if (tr instanceof ArrayTypeReference) {
					returnType =
						new ArrayTypeFromTypeReference((ArrayTypeReference) tr);
				} else if (tr instanceof SingleTypeReference) {
					returnType = new SimpleTypeFromTypeReference(tr);
				} else if (tr instanceof QualifiedTypeReference) {
					returnType = new SimpleTypeFromTypeReference(tr);
				}
			}
		}
		return returnType;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration#getBody()
	 */
	public IBlock getBody() {
		if (md.isAbstract())
			return null;
		if (body == null) {
			if (md.isConstructor()) {
				ExplicitConstructorCall ecc =
					(
						(
							org
								.eclipse
								.jdt
								.internal
								.compiler
								.ast
								.ConstructorDeclaration) md)
								.constructorCall;
				if (ecc != null && ecc.sourceStart > md.bodyStart) {
					int oldLength =
						(md.statements == null) ? 0 : md.statements.length;
					Statement[] statements = new Statement[oldLength + 1];
					for (int i = 0; i < oldLength; i++) {
						statements[i + 1] = md.statements[i];
					}
					statements[0] = ecc;
					body =
						new Block(
							statements,
							md.bodyStart,
							md.bodyEnd,
							md.scope,
							source);
				} else {
					body =
						new Block(
							md.statements,
							md.bodyStart,
							md.bodyEnd + 1,
							md.scope,
							source);
				}
			} else {
      body =
        new Block(
          md.statements,
          md.bodyStart,
          md.bodyEnd + 1,
          md.scope,
          source);
			}

		}
		return body;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration#resolveBinding()
	 */
	public IMethodBinding resolveBinding() {
		return new MethodBinding(md.binding);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBodyDeclaration#getJavadoc()
	 */
	public IJavadoc getJavadoc() {
		if (javadoc == null) {
			javadoc = source.getJavadoc(md.declarationSourceStart);
		}
		return javadoc;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment[] getComments() {
		if (comments == null) {
			comments = source.getBlockComment(md.sourceEnd + 1);
		}
		return comments;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IStatement#getComments()
	 */
	public IComment getEndOfLineComment() {
		if (!commentParsed) {
			endOfLineComment = source.getEndOfLineComment(md.sourceStart);
      commentParsed = true;
		}
		return endOfLineComment;
	}

	public void traverse(IVisitor visitor) {

		if (visitor.visit(this)) {
			IType returnType = getReturnType();
			if (returnType != null)
				returnType.traverse(visitor);
			List arguments = parameters();
			if (arguments != null) {
				Iterator iterator = arguments.iterator();
				while (iterator.hasNext())
					 ((Traversable) iterator.next()).traverse(visitor);
			}
			List thrownExceptions = thrownExceptions();
			if (thrownExceptions != null) {
				Iterator iterator = thrownExceptions.iterator();
				while (iterator.hasNext())
					 ((Traversable) iterator.next()).traverse(visitor);
			}
			IBlock body = getBody();
			if (body != null)
				body.traverse(visitor);
		}
		visitor.endVisit(this);
	}

}
