/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/MethodBinding.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;


public class MethodBinding implements IMethodBinding {

     org.eclipse.jdt.internal.compiler.lookup.MethodBinding binding;
 
     public MethodBinding(org.eclipse.jdt.internal.compiler.lookup.MethodBinding binding) {
     	this.binding = binding;
     } 

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding#isConstructor()
	 */
	public boolean isConstructor() {
		return binding.isConstructor();
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#getName()
	 */
	public String getName() {
        return new String(binding.selector);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding#getDeclaringClass()
	 */
	public IReferenceTypeBinding getDeclaringClass() {
		return BindingFactory.getReferenceTypeBinding(binding.declaringClass);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding#getParameterTypes()
	 */
	public ITypeBinding[] getParameterTypes() {
		org.eclipse.jdt.internal.compiler.lookup.TypeBinding[] parameters = binding.parameters;
		ITypeBinding[] out = new ITypeBinding[parameters.length];
		for ( int i = 0; i < out.length; i++ )
		    out[i] = BindingFactory.getTypeBinding(parameters[i]);
		return out;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding#getReturnType()
	 */
	public ITypeBinding getReturnType() {
		return BindingFactory.getTypeBinding(binding.returnType);
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding#getExceptionTypes()
	 */
	public IReferenceTypeBinding[] getExceptionTypes() {
		org.eclipse.jdt.internal.compiler.lookup.TypeBinding[] parameters = binding.thrownExceptions;
		IReferenceTypeBinding[] out = new IReferenceTypeBinding[parameters.length];
		for ( int i = 0; i < out.length; i++ )
		    out[i] = BindingFactory.getReferenceTypeBinding((ReferenceBinding)parameters[i]);
		return out;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#getKind()
	 */
	public int getKind() {
		return IBinding.METHOD;
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#getModifiers()
	 */
	public int getModifiers() {
		return binding.modifiers & 0x0fff; // first byte used jdt-internally
	}

	/**
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#isDeprecated()
	 */
	public boolean isDeprecated() {
		return binding.isDeprecated();
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.jom.interfaces.IBinding#equals(com.sap.tc.jtools.jlint.jom.interfaces.IBinding)
	 */
	public boolean equals(Object object) {
		return (object instanceof MethodBinding) && (((MethodBinding)object).binding.equals(this.binding));
	}

  /* (non-Javadoc)
   * @see java.lang.Object#hashCode()
   */
  public int hashCode() {
    return binding.hashCode();
  }

}
