/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/ciwrappers2_1/JavadocParser.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.interfaces.IJavadoc;

/**
 *  
 * <p>
 * Copyright (c) 2003, SAP AG
 */
public class JavadocParser {

	public static IJavadoc getJavadoc(char[] source, int initialPosition) {

		int start = -1;
		int currentPosition = initialPosition;
		while (Character.isWhitespace(source[currentPosition++]));
		if (source[currentPosition - 1] == '/'
			&& source[currentPosition] == '*'
			&& source[currentPosition + 1] == '*') {
			start = currentPosition - 1;
			currentPosition += 2;
			for (;; currentPosition++) {
				if (source[currentPosition] == '*'
					&& source[currentPosition + 1] == '/')
					return new Javadoc(
						new String(source, start, currentPosition + 2 - start),
						start);
			}
		}
		return null;
	}
}
